--[[
  @srp-core.dll FFI api wrapper
  Copyright Samp-Rp.Ru 2025
]]

local M = {}

local ffi = require("ffi")

ffi.cdef[[
  struct _SRP_StreamingStats {
    unsigned int structSize; // sizeof(SRP_StreamingStats)
    unsigned int streamMemoryMax;
    unsigned int streamMemoryUsage;
    struct {
      unsigned int totalMax;
      unsigned int totalUsage;
      unsigned int atomicsCount;
      unsigned int loadedAtomicsCount;
      unsigned int timesCount;
      unsigned int loadedTimesCount;
      unsigned int weaponsCount;
      unsigned int loadedWeaponsCount;
      unsigned int clumpsCount;
      unsigned int loadedClumpsCount;
      unsigned int vehiclesCount;
      unsigned int loadedVehiclesCount;
      unsigned int pedsCount;
      unsigned int loadedPedsCount;
      unsigned int lodsCount;
      unsigned int loadedLodsCount;
    } modelInfos;
    struct {
      unsigned int max;
      unsigned int usage;
    } vehicleStructPool;
  };
  typedef struct _SRP_StreamingStats SRP_StreamingStats;

  // get game streaming stats
  // returns success
  bool __cdecl SRP_FetchStreamingStats(SRP_StreamingStats* out);
]]

local lib = ffi.load("@srp-core.dll")
M._lib = lib

function M.fetchStreamingStats()
  local struct = ffi.new("SRP_StreamingStats")
  struct.structSize = ffi.sizeof("SRP_StreamingStats")

  local success = lib.SRP_FetchStreamingStats(struct)

  if not success then
    return nil
  end

  return struct
end

return M
